<?php

/**
 * @Module Name: 1Pay Payments | OpenCart
 * Plugin URI: http://1pay.in
 * Description: Extends OpenCart with 1Pay services
 * Version: 1.0.3
 * @author: Soumil Gada, Manisha Gupta
 * Author EMAIL: soumil.gada@mobilewaretech.com
 * @copyright: @2018 Mobilewaretech. All rights reserved
 */
class ControllerExtensionPaymentOnepay extends Controller {

    private $ekey = '3a5c1c4e81d7eb133a5c1c4e81d7eb13';

    public function index() {
        global $_SERVER;
        $data['button_confirm'] = $this->language->get('button_confirm');

        $this->load->model('checkout/order');
        $this->load->language('extension/payment/onepay');

        $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

        if ($this->config->get('payment_onepay_server') == 'live') {
            $url = 'https://pay.1paypg.in/payone/';
            // $collaborator= 'Onepay';
        } elseif ($this->config->get('payment_onepay_server') == 'test') {
            $url = 'http://139.59.1.254:8080/onepayVAS/';
            // $collaborator= 'TOML';
        }


        $total = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false);
        $total = sprintf("%.2f", $total);

        $orderno = 'ORD' . $order_info['order_id'];

        $key = $this->config->get('payment_onepay_key');
        $merchantId = $this->config->get('payment_onepay_merchant');

        $b_address1 = $order_info['payment_address_1'];
        $b_address2 = $order_info['payment_address_2'];


        $data['txnId'] = $orderno . "_" . date("ymds");
        $data['dateTime'] = date('Y-m-d h:i:s');
        $data['amount'] = $total;
        $data['custMobile'] = $order_info['telephone'];
        $data['custMail'] = $order_info['email'];
        $data['returnUrl'] = $this->url->link('extension/payment/onepay/callback', '', true);
        $data['apiKey'] = $key;
        $data['url'] = $url;
        $data['merchantId'] = $merchantId;
        $data['checksum'] = $this->checksum($data);
        $data['isMultiSettlement'] = '0';
        $data['udf1'] = 'NA';
        $data['udf2'] = 'NA';
        $data['udf3'] = 'NA';
        $data['cardType'] = 'NA';
        $data['cardDetails'] = 'NA';
        $data['udf4'] = 'NA';
        $data['udf5'] = 'NA';

        $jsondata = json_encode($data);
        $enc = $this->get_encrypt($jsondata);

        // $data['action'] = $url . 'payprocessor';

        $details = array();
        $details['merchantId'] = $merchantId;
        $details['enc'] = $enc;
        $details['action'] = $url . 'payprocessor';

        if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . 'extension/payment/onepay')) {
            return $this->load->view($this->config->get('config_template') . 'extension/payment/onepay', $details);
        } else {
            return $this->load->view('extension/payment/onepay', $details);
        }
    }

    function get_string_between($string, $start, $end) {
        $string = ' ' . $string;
        $ini = strpos($string, $start);
        if ($ini == 0)
            return '';
        $ini += strlen($start);
        $len = strpos($string, $end, $ini) - $ini;
        return substr($string, $ini, $len);
    }

    function request($url, $postData) {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

        $data = curl_exec($ch);
        curl_close($ch);
        return json_decode($data);
    }

    function checksum($data) {
        $url = $data['url'] . 'checksumgenerator';
        $myvars = "merchantId=" . $data['merchantId'] . "&txnId=" . $data['txnId'] . "&dateTime=" . $data['dateTime'] . "&amount=" . $data['amount'] . "&apiKey=" . $data['apiKey'] . "&custMobile=" . $data['custMobile'] . "&custMail=" . $data['custMail'] . "&channelId=0&txnType=DIRECT";

        $checksum = $this->request($url, $myvars);
        // $checksum1 = $this->get_string_between($checksum,"<checksum>","</checksum>"); 
        return $checksum->checksum;
    }

    function verify($data) {
        $url = $data['url'] . 'getTxnDetails';
        //$myvars = "respData=" . $data['respData'] . "";
        $txnid = $data['respData']->txn_id;
        $merchantid = $data['respData']->merchant_id;

        $myvars = "merchantId=" . $merchantid . "&txnId=" . $txnid . "";

        $resdata = $this->request($url, $myvars);
        return $resdata;
    }

    public function callback() {



        if ($this->config->get('payment_onepay_server') == 'live') {
            $url = 'https://pay.1paypg.in/payone/';
        } elseif ($this->config->get('payment_onepay_server') == 'test') {
            $url = 'http://139.59.1.254:8080/onepayVAS/';
        }


        $this->load->model('checkout/order');
        $key = $this->config->get('payment_onepay_key');
        $merchantId = $this->config->get('payment_onepay_merchant');

        $pdata = '';
        if (isset($_POST['respData'])) {
            $resData = $_POST['respData'];
            $respDecrypt = $this->get_decrypt($respData);

            $verificationResult = json_decode($respDecrypt);
        } else {
            //invalid return data
            $this->session->data['error'] = "Transaction error ....";
            $this->response->redirect($this->url->link('checkout/checkout', '', true));
            return;
        }


        $verificationResult = $this->verify(array('respData' => $verificationResult, 'url' => $url));

        $parsedtxnid = $verificationResult->txn_id;
        $parsedmerchantid = $verificationResult->merchant_id;
        $parsedtxnamount = $verificationResult->txn_amount;
        $parsedtxnstatus = $verificationResult->trans_status;
        $responseMessage = $verificationResult->resp_message;

        $orderid = explode("_", $parsedtxnid);
        $orderid = $orderid[0];

        if (($responseMessage === 'No Error.') && ($parsedtxnstatus !== 'NA')) {

            $vmessage = "Verified Transaction";
            if ($parsedtxnstatus == 'Ok') {
                $status_msg = "Transaction Successful";
                $this->model_checkout_order->addOrderHistory($orderid, $this->config->get('payment_onepay_order_status_id'), 'Payment Successful', true);
                $this->response->redirect($this->url->link('checkout/success', '', true));
            } else if ($parsedtxnstatus == 'To') {
                $status_msg = "Sorry!!Your Transaction is Timed Out";
            } else {
                $status_msg = "Transaction Failed";
            }
        } else {
            $vmessage = "Transaction  Failed";

            $status_msg = "Transaction Failed";
            $this->model_checkout_order->addOrderHistory($orderid, $this->config->get('payment_onepay_order_fail_status_id'), $status_msg, true);
            $this->session->data['error'] = "Onepay Response - " . $status_msg;
            $this->response->redirect($this->url->link('checkout/checkout', '', 'SSL'));
        }
    }

    public function get_encrypt($input) {

        //for php 5.x.x to 7.0.x
        $key = $this->ekey;
        $size = mcrypt_get_block_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_ECB);

        $input = $this->get_pkcs5_pad($input, $size);

        $td = mcrypt_module_open(MCRYPT_RIJNDAEL_128, '', MCRYPT_MODE_ECB, '');

        $iv = mcrypt_create_iv(mcrypt_enc_get_iv_size($td), MCRYPT_RAND);

        mcrypt_generic_init($td, $key, $iv);
        $data = mcrypt_generic($td, $input);

        mcrypt_generic_deinit($td);
        mcrypt_module_close($td);
        $data = base64_encode($data);

        //die;
        return $data;
    }

    protected function get_pkcs5_pad($text, $blocksize) {
        $pad = $blocksize - (strlen($text) % $blocksize);
        return $text . str_repeat(chr($pad), $pad);
    }

    public function get_decrypt($input) {
        $key = $this->ekey;
        $decrypted = mcrypt_decrypt(
                MCRYPT_RIJNDAEL_128, $key, base64_decode($input), MCRYPT_MODE_ECB
        );
        $dec_s = strlen($decrypted);
        $padding = ord($decrypted[$dec_s - 1]);
        $decrypted = substr($decrypted, 0, -$padding);


        return $decrypted;
    }

}

?>
