<?php
/**
 * @Module Name: 1Pay Payments | OpenCart
 * Plugin URI: http://1pay.in
 * Description: Extends OpenCart with 1Pay services
 * Version: 1.0.3
 * @author: Soumil Gada, Manisha Gupta
 * Author EMAIL: soumil.gada@mobilewaretech.com
 * @copyright: @2018 Mobilewaretech. All rights reserved
 */

class ControllerExtensionPaymentOnepay extends Controller {
	private $error = array(); 

	public function index() {
		$this->load->language('extension/payment/onepay');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('setting/setting');
			
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('payment_onepay', $this->request->post);				
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true));

		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_all_zones'] = $this->language->get('text_all_zones');
		$data['text_test'] = $this->language->get('text_test');
		$data['text_live'] = $this->language->get('text_live');

		$data['entry_merchant'] = $this->language->get('entry_merchant');
		$data['entry_security'] = $this->language->get('entry_encryption_key');
		$data['help_merchant'] = $this->language->get('help_merchant');
		$data['help_key'] = $this->language->get('help_key');
		//$data['entry_callback'] = $this->language->get('entry_callback');
		$data['entry_server'] = $this->language->get('entry_server');
		$data['entry_total'] = $this->language->get('entry_total');	
		$data['entry_order_status'] = $this->language->get('entry_order_status');		
		$data['entry_order_fail_status'] = $this->language->get('entry_order_fail_status');		
		$data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		$data['tab_general'] = $this->language->get('tab_general');

  		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

 		if (isset($this->error['merchant'])) {
			$data['error_merchant'] = $this->error['merchant'];
		} else {
			$data['error_merchant'] = '';
		}

 		if (isset($this->error['security'])) {
			$data['error_security'] = $this->error['security'];
		} else {
			$data['error_security'] = '';
		}
		
  		$data['breadcrumbs'] = array();

   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true),
      		'separator' => false
   		);

   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_payment'),
			'href'      => $this->url->link('extension/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true),
      		'separator' => ' :: '
   		);

   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('extension/payment/onepay', 'user_token=' . $this->session->data['user_token'], true),
      		'separator' => ' :: '
   		);
				
		$data['action'] = $this->url->link('extension/payment/onepay', 'user_token=' . $this->session->data['user_token'], true);
		
		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'], 'SSL');
		
		if (isset($this->request->post['payment_onepay_merchant'])) {
			$data['payment_onepay_merchant'] = $this->request->post['payment_onepay_merchant'];
		} else {
			$data['payment_onepay_merchant'] = $this->config->get('payment_onepay_merchant');
		}
		if (isset($this->request->post['payment_onepay_server'])) {
			$data['payment_onepay_server'] = $this->request->post['payment_onepay_server'];
		} else {
			$data['payment_onepay_server'] = $this->config->get('payment_onepay_server');
		}

	if (isset($this->request->post['payment_onepay_key'])) {
			$data['payment_onepay_key'] = $this->request->post['payment_onepay_key'];
		} else {
			$data['payment_onepay_key'] = $this->config->get('payment_onepay_key');
		}
		if (isset($this->request->post['payment_onepay_order_status_id'])) {
			$data['payment_onepay_order_status_id'] = $this->request->post['payment_onepay_order_status_id'];
		} else {
			$data['payment_onepay_order_status_id'] = $this->config->get('payment_onepay_order_status_id'); 
		} 
		if (isset($this->request->post['payment_onepay_order_fail_status_id'])) {
			$data['payment_onepay_order_fail_status_id'] = $this->request->post['payment_onepay_order_fail_status_id'];
		} else {
			$data['payment_onepay_order_fail_status_id'] = $this->config->get('payment_onepay_order_fail_status_id'); 
		} 
		$this->load->model('localisation/order_status');
		
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['payment_onepay_status'])) {
			$data['payment_onepay_status'] = $this->request->post['payment_onepay_status'];
		} else {
			$data['payment_onepay_status'] = $this->config->get('payment_onepay_status');
		}
		
		if (isset($this->request->post['payment_onepay_sort_order'])) {
			$data['payment_onepay_sort_order'] = $this->request->post['payment_onepay_sort_order'];
		} else {
			$data['payment_onepay_sort_order'] = $this->config->get('payment_onepay_sort_order');
		}		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		$this->response->setOutput($this->load->view('extension/payment/onepay', $data));
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'extension/payment/onepay')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!$this->request->post['payment_onepay_merchant']) {
			$this->error['merchant'] = $this->language->get('error_merchant');
		}

		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}	
	}
}
?>