<?php 
/**
 * @Module Name: 1Pay Payments | OpenCart
 * Plugin URI: http://1pay.in
 * Description: Extends OpenCart with 1Pay services
 * Version: 1.0.2
 * @author: Soumil Gada
 * Author EMAIL: soumil.gada@mobilewaretech.com
 * @copyright: @2018 Mobilewaretech. All rights reserved
 */

class ControllerExtensionPaymentOnepay extends Controller {
	
	public function index() {
		global $_SERVER;
		$data['button_confirm'] = $this->language->get('button_confirm');

		$this->load->model('checkout/order');
		$this->load->language('extension/payment/onepay');
		
		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

		if ($this->config->get('payment_onepay_server') == 'live') {
    		$url = 'https://pay.1paypg.in/payone/';
			// $collaborator= 'Onepay';
		} elseif ($this->config->get('payment_onepay_server') == 'test') {
			$url = 'http://139.59.1.254:8080/payone/';	
			// $collaborator= 'TOML';
		}	
		
		
		$total = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false);
		$total = sprintf("%.2f", $total);
		
		$orderno = 'ORD'.$order_info['order_id'];		

		$key = $this->config->get('payment_onepay_key');
		$merchantId= $this->config->get('payment_onepay_merchant');
		
		$b_address1 = $order_info['payment_address_1'];
		$b_address2 = $order_info['payment_address_2'];
	

		$data['txnId'] = $orderno."_".date("ymds");
		$data['dateTime'] = date('Y-m-d h:i:s');
		$data['amount'] = $total;
		$data['custMobile'] = $order_info['telephone'];
		$data['custMail'] = $order_info['email'];
		$data['returnUrl'] = $this->url->link('extension/payment/onepay/callback','',true);
		$data['apiKey'] = $key;
		$data['url'] = $url;
		$data['merchantId']   =	$merchantId;
		$data['checksum'] = $this->checksum($data);
		$data['isMultiSettlement'] = '0';
		$data['udf1'] = 'NA';
		$data['udf2'] = 'NA';
		$data['udf3'] = 'NA';
		$data['cardType'] = 'NA';
		
		$data['action'] = $url.'payprocessor';		
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . 'extension/payment/onepay')) {
				return $this->load->view($this->config->get('config_template') . 'extension/payment/onepay', $data);
			} else {
				return $this->load->view('extension/payment/onepay', $data);
			}	
	}

	function get_string_between($string, $start, $end){
	    $string = ' ' . $string;
	    $ini = strpos($string, $start);
	    if ($ini == 0) return '';
	    $ini += strlen($start);
	    $len = strpos($string, $end, $ini) - $ini;
	    return substr($string, $ini, $len);
	}

	function request($url,$postData){
		$ch = curl_init( $url );
		curl_setopt( $ch, CURLOPT_POST, 1);
		curl_setopt( $ch, CURLOPT_POSTFIELDS, $postData);
		curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt( $ch, CURLOPT_HEADER, 0);
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1);

		$data = curl_exec($ch);
		curl_close($ch);
		return json_decode($data);
	}

	function checksum($data){
		$url = $data['url'].'checksumgenerator';
		$myvars = "merchantId=".$data['merchantId']."&txnId=".$data['txnId']."&dateTime=".$data['dateTime']."&amount=".$data['amount']."&apiKey=".$data['apiKey']."&custMobile=".$data['custMobile']."&custMail=".$data['custMail']."&channelId=0&txnType=DIRECT";
		
		$checksum = $this->request($url,$myvars);
		// $checksum1 = $this->get_string_between($checksum,"<checksum>","</checksum>"); 
		return $checksum->checksum;
	}

	function verify($data){
		$url = $data['url'].'verifyTxn';
		$myvars = "respData=".$data['respData']."";
		
		$resdata = $this->request($url,$myvars);
		return $resdata;
	}
	
	public function callback() {
		


		if ($this->config->get('payment_onepay_server') == 'live') {
    		$url = 'https://pay.1paypg.in/payone/';
		} elseif ($this->config->get('payment_onepay_server') == 'test') {
			$url = 'http://139.59.1.254:8080/payone/';	
		}	
		

		$this->load->model('checkout/order');
		$key = $this->config->get('payment_onepay_key');
		$merchantId= $this->config->get('payment_onepay_merchant');
		
		$pdata = '';
		if (isset($_POST['respData'])) {
			$resData = $_POST['respData'];				
		}
		else
		{
			//invalid return data
			$this->session->data['error'] = "Transaction error ....";		
			$this->response->redirect($this->url->link('checkout/checkout', '', true));
			return;
		}
		
		// $txnid = $pdata['txn_id'];
		// $merchantid = $pdata['merchant_id'];
		// $pgRefId = $pdata['pg_ref_id'];
		// $txndateTime = $pdata['resp_date_time'];
		// $txnstatus = $pdata['trans_status'];
		// $txnamount = $pdata['txn_amount'];
		// $message = $pdata['message'];
		// $email = $pdata['Email'];
		// $phnumber = $pdata['Phone'];
		// $banktxnId = $pdata['bank_txn_id'];
		// $dateTime = $pdata['datetime'];



		$verificationResult = $this->verify(array('respData'=>$resData,'url'=>$url));

		$parsedtxnid = $verificationResult->txn_id;
        $parsedmerchantid = $verificationResult->merchant_id;
        $parsedtxnamount = $verificationResult->txn_amount;
        $parsedtxnstatus = $verificationResult->trans_status;
        $responseMessage = $verificationResult->resp_message;
            		
		$orderid=explode("_",$parsedtxnid);
		$orderid=$orderid[0];

		if (($responseMessage === 'No Error.') && ($parsedtxnstatus !== 'NA')) {
		// if(($txnid == $parsedtxnid )&& ($txnamount == $parsedtxnamount) && ($merchantid == $parsedmerchantid)){
			$vmessage = "Verified Transaction";
				if($parsedtxnstatus == 'Ok'){
					$status_msg = "Transaction Successful";
					$this->model_checkout_order->addOrderHistory($orderid, $this->config->get('payment_onepay_order_status_id'),'Payment Successful',true);
					$this->response->redirect($this->url->link('checkout/success', '', true));			
				}
				else if($parsedtxnstatus == 'To'){
					$status_msg = "Sorry!!Your Transaction is Timed Out";
				}
				else{
					$status_msg = "Transaction Failed";
				}
		}
		else
		{
			$vmessage = "Transaction  Failed";
					// if($txnid != $parsedtxnid)
					// {
					$status_msg = "Transaction Failed";
					$this->model_checkout_order->addOrderHistory($orderid, $this->config->get('payment_onepay_order_fail_status_id'),$status_msg,true);					
					$this->session->data['error'] = "Onepay Response - ".$status_msg;
					$this->response->redirect($this->url->link('checkout/checkout', '', 'SSL'));
					// }
					// if($txnStatus != $parsedtxnstatus)
					// {
					// 	$status_msg = "Transaction Failed beacuse of Status Mismatch in Verification";
					// 	$this->model_checkout_order->addOrderHistory($orderid, $this->config->get('payment_onepay_order_fail_status_id'),$status_msg,true);					
					// 	$this->session->data['error'] = "Onepay Response - ".$status_msg;
					// 	$this->response->redirect($this->url->link('checkout/checkout', '', 'SSL'));
					// }
					// if($txnamount != $parsedtxnamount)
					// {
					// 	$status_msg = "Transaction Failed beacuse of Amount Mismatch in Verification";
					// 	$this->model_checkout_order->addOrderHistory($orderid, $this->config->get('payment_onepay_order_fail_status_id'),$status_msg,true);					
					// 	$this->session->data['error'] = "Onepay Response - ".$status_msg;
					// 	$this->response->redirect($this->url->link('checkout/checkout', '', 'SSL'));
					// }
		}

	}
}
?>
